
/*

stats.cpp

Maintain/display ZeriLink transfer statistics

Version : 1.00
Author  : John Kortink, (c) Zeridajh 2006

*/

#include <sstream>
#include <iostream>
#include "math.h"
#include "stats.h"

void Statistics::Initialise(long bytes_total)
//
//
// Initialise transfer statistics
//
//
{
	total_bytes = bytes_total;

	bytes_done = 0;

	if (Be_Verbose)
	{
		percentage = 0;

		cout << " : 0%" << flush;
	}

	start_time = clock();
}

void Statistics::New_Percentage(long new_percentage)
//
//
// Set & display statistics percentage
//
//
{
	if (Be_Verbose)
	{
		string back_spaces(((percentage == 0) ? 0 : int(log10(double(percentage)))) + 2, '\b');

		percentage = new_percentage;

		cout << back_spaces << percentage << "%" << flush;
	}
}

void Statistics::Update(long done_bytes)
//
//
// Update transfer statistics
//
//
{
	bytes_done += done_bytes;

	New_Percentage((total_bytes > 0) ? (long) (double(bytes_done) * 100 / double(total_bytes)) : 100);
}

void Statistics::Finalise(void)
//
//
// Finalise transfer statistics
//
//
{
	clock_t		expired_clocks;

	end_time = clock();

	expired_clocks = end_time - start_time;

	if (expired_clocks <= 0)
		expired_clocks = 1;

	bytes_per_second = (long) (double(total_bytes) / (double(expired_clocks) / double(CLOCKS_PER_SEC)));

	if (Be_Verbose)
	{
		New_Percentage(100);

		cout << ", " << bytes_per_second << " bytes/sec" << flush;
	}
}



